/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.rendering;

import dangerzone.DangerZone;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ShaderStuff {
    public void initShaders() {
        DangerZone.model_shader = this.shaderInit("ModelVertexShader.txt", "ModelFragmentShader.txt");
        if (DangerZone.model_shader == -1) {
            System.out.println("Failed to initialise model shader");
            System.exit(1);
        }
    }

    private String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block36: {
            source = new StringBuilder();
            FileInputStream in = new FileInputStream(filename);
            Exception exception = null;
            try {
                try {
                    Exception innerExc;
                    block32: {
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                        innerExc = null;
                        try {
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    source.append(line).append('\n');
                                }
                            }
                            catch (Exception exc) {
                                exception = exc;
                                try {
                                    reader.close();
                                }
                                catch (Exception exc2) {
                                    if (innerExc == null) {
                                        innerExc = exc2;
                                        break block32;
                                    }
                                    exc2.printStackTrace();
                                }
                                break block32;
                            }
                        }
                        catch (Throwable throwable) {
                            block33: {
                                try {
                                    reader.close();
                                }
                                catch (Exception exc) {
                                    if (innerExc == null) {
                                        innerExc = exc;
                                        break block33;
                                    }
                                    exc.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        try {
                            reader.close();
                        }
                        catch (Exception exc) {
                            if (innerExc == null) {
                                innerExc = exc;
                            }
                            exc.printStackTrace();
                        }
                    }
                    if (innerExc != null) {
                        throw innerExc;
                    }
                }
                catch (Exception exc) {
                    block35: {
                        exception = exc;
                        try {
                            in.close();
                        }
                        catch (Exception exc3) {
                            if (exception == null) {
                                exception = exc3;
                                break block35;
                            }
                            exc3.printStackTrace();
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                block37: {
                    try {
                        in.close();
                    }
                    catch (Exception exc) {
                        if (exception == null) {
                            exception = exc;
                            break block37;
                        }
                        exc.printStackTrace();
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exc) {
                if (exception == null) {
                    exception = exc;
                }
                exc.printStackTrace();
            }
            if (exception != null) {
                throw exception;
            }
        }
        return source.toString();
    }

    public void removeShaders() {
        GL20.glDeleteProgram((int)DangerZone.model_shader);
    }

    public int shaderInit(String vsn, String fsn) {
        String fragmentShader;
        String vertexShader;
        String l_dir = "./";
        try {
            Path currentRelativePath = Paths.get("", new String[0]);
            String s = currentRelativePath.toAbsolutePath().toString();
            System.out.println("Current relative path is: " + s);
            vertexShader = this.readFileAsString(String.valueOf(l_dir) + vsn);
            fragmentShader = this.readFileAsString(String.valueOf(l_dir) + fsn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        int program = GL20.glCreateProgram();
        int errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to create shader program");
            return -1;
        }
        int vertex_shader = GL20.glCreateShader((int)35633);
        errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to create vertex shader");
            return -1;
        }
        GL20.glShaderSource((int)vertex_shader, (CharSequence)vertexShader);
        errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to load vertex shader string");
            return -1;
        }
        GL20.glCompileShader((int)vertex_shader);
        int isCompiled = GL20.glGetShaderi((int)vertex_shader, (int)35713);
        if (isCompiled == 0) {
            String shaderLog = GL20.glGetShaderInfoLog((int)vertex_shader);
            System.err.println("Failed to compile vertex shader");
            System.err.println(shaderLog);
            return -1;
        }
        GL20.glAttachShader((int)program, (int)vertex_shader);
        errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to attach vertex shader to program");
            return -1;
        }
        int fragment_shader = GL20.glCreateShader((int)35632);
        errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to create fragment shader");
            return -1;
        }
        GL20.glShaderSource((int)fragment_shader, (CharSequence)fragmentShader);
        errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to load fragment shader");
            return -1;
        }
        GL20.glCompileShader((int)fragment_shader);
        isCompiled = GL20.glGetShaderi((int)fragment_shader, (int)35713);
        if (isCompiled == 0) {
            String shaderLog = GL20.glGetShaderInfoLog((int)fragment_shader);
            System.err.println("Failed to compile fragment shader");
            System.err.println(shaderLog);
            return -1;
        }
        GL20.glAttachShader((int)program, (int)fragment_shader);
        errorCheckValue = GL11.glGetError();
        if (errorCheckValue != 0) {
            System.err.println("Failed to attach fragment shader to program");
            return -1;
        }
        GL20.glLinkProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35714) == 0) {
            System.err.println("Failed to link program");
            System.err.println(GL20.glGetProgramInfoLog((int)program, (int)GL20.glGetProgrami((int)program, (int)35716)));
            return -1;
        }
        GL20.glValidateProgram((int)program);
        if (GL20.glGetProgrami((int)program, (int)35715) == 0) {
            System.err.println("Failed to validate program");
            System.err.println(GL20.glGetProgramInfoLog((int)program, (int)GL20.glGetProgrami((int)program, (int)35716)));
            return -1;
        }
        System.out.println("Created program Id " + program);
        GL20.glDetachShader((int)program, (int)vertex_shader);
        GL20.glDetachShader((int)program, (int)fragment_shader);
        GL20.glDeleteShader((int)vertex_shader);
        GL20.glDeleteShader((int)fragment_shader);
        return program;
    }
}

